/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.audio;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.files.FileHandle;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Singleton
public class MusicJukebox {
    private List<FileHandle> musicFileList = new ArrayList<FileHandle>();
    private int trackCursor = 0;
    private Music currentTrack;

    @Inject
    public MusicJukebox() {
        FileHandle musicDir = new FileHandle("assets/music");
        FileHandle mainMusic = null;
        for (FileHandle fileHandle : musicDir.list()) {
            if (!fileHandle.extension().equals("ogg")) continue;
            this.musicFileList.add(fileHandle);
            if (!fileHandle.name().contains("Jordan Chin")) continue;
            mainMusic = fileHandle;
        }
        if (mainMusic != null) {
            this.musicFileList.remove(mainMusic);
        }
        Collections.shuffle(this.musicFileList);
        this.musicFileList.add(0, mainMusic);
    }

    public void update() {
        if (this.currentTrack == null || !this.currentTrack.isPlaying()) {
            this.startNewTrack();
        }
    }

    private void startNewTrack() {
        if (this.currentTrack != null) {
            this.currentTrack.dispose();
        }
        this.currentTrack = Gdx.audio.newMusic(this.musicFileList.get(this.trackCursor));
        ++this.trackCursor;
        if (this.trackCursor >= this.musicFileList.size()) {
            this.trackCursor = 0;
        }
        this.currentTrack.play();
    }
}

